#include "univ.h"

char *itoa(n)
register n;
{
	register char *pic = " [-][0-9]* ";
	char cip[10];
	register char *p = pic, *c;

	*p++ = ' ';
	if (n < 0)
		*p++ = '-', n = -n;
	*(c = &cip[0]) = '\0';
	do {
		*++c = "0123456789"[n%10];
	} while (n = n/10);
	while(*c)
		*p++ = *c--;
	*p++ = ' ';
	*p = '\0';
	return pic;
}
	
dictorder(a, b)
register char *a, *b;
{
	register disc;

	for(;;) {
		if (!*a)
			return 1;
		if (!*b)
			return 0;
		if (disc = (*a++|' ')-(*b++|' '))
			return disc<0;
	}
}

#ifdef ASSERT
long assertf(l)
long l;
{
	if (l)
		return l;
	fprintf(stderr, "pads: assert failed\n");
	/* Force core dump */
	*(int *)0 = 0;
	exit(1);
}
#endif

char *Alloc(n)
{
	char *a;

	if (!(a = (char*)calloc(n, 1))) {
		fprintf(stderr, "pads: Alloc: out of memory\n");
		exit(1);
	}
	return a;
}

char *GCAlloc(n, p)
register char **p;
{
	register unsigned long nbytes = n;
	
	*p = (char*)calloc(nbytes, 1);
	if (!*p) {
		fprintf(stderr, "pads: GCAlloc: out of memory\n");
		exit(1);
	}
	return *p;
}

GCString(p, s)
char **p, *s;
{
	*p = GCAlloc(strlen(s)+1, p);
	strcpy(*p, s);
}

void
gcfree (s)
char *s;
{
	if (s != 0)
		free(s);
}
